;MASTER.GEO
;PROJECT=Metro/Tube/Underground

;INCLUDE

GLOBAL flat_ceiling = FALSE
GLOBAL use_trains = TRUE

ABS default = <10 10 10 10 10 10> ;L <10 10 10 10 10 10>

GLOBAL pw  = 10 ; platform width
GLOBAL wh  = 8  ; wall height
GLOBAL sl   = 60 ; station length
GLOBAL ep = 2  ; entrance position
GLOBAL ew = 5  ; entrance width
GLOBAL ed = 3  ; entrance depth
GLOBAL eh = 3  ; entrance height
GLOBAL sd = 5  ; stair depth
GLOBAL sh = 2  ; stair height
GLOBAL tlevel = -1  ; track level below platform

GLOBAL trw = 2 ; train carriage width
GLOBAL trh = 3 ; train carriage height (from the tracks)
GLOBAL trd = 1 ; distance between trains
GLOBAL tw  = 2*trw+trd  ; total width tracks and distances (2 tracks) width
GLOBAL tunh = trh + 0.5; tunnel height

GLOBAL side_ah = wh-1 ; height where upper side wall absorbers start

IF -flat_ceiling THEN
   LOCAL zh = 0.2 ; the height of the zeiling arc
   LOCAL a = 15 ; ceiling arch division
   LOCAl r = 0.5*(2*pw+tw) ; derrived
ENDIF

ABS platform_abs = <2 2 2 2 3 3> L <10 15 20 20 20 20>
ABS usidewall_abs = <30 40 50 60 70 80> L <30 30 30 30 30 30> ; upper side wall abs
ABS lsidewall_abs = <12 10 8 8 7 6> L <30 30 30 30 30 30> ; lower side wall abs
ABS uendwall_abs = usidewall_abs ; upper end wall abs
ABS lendwall_abs = lsidewall_abs ; lower end wall abs
ABS stair_abs = <6 6 7 7 8 8 > L <30 40 50 60 70 80>; OBS put diffusion on stairs!
ABS stairwall_abs = lsidewall_abs
ABS stairceil_abs = usidewall_abs

ABS opening = <95 95 95 95 95 95>
;instead of using TOTABS (or say 95%) on openings make them visibly open (white in  
;Shaded.PLT) set "Plane Use/not some" in General settings to planes 8,15,16,208.

ABS trackwall_abs = <10 8 8 8 7 6> L <30 30 30 30 30 30> 
ABS track_abs = default <20 15 12 10 10 10> L <30 40 50 50 55 60> ; OBS diffusion
ABS train_abs = <12 10 8 8 7 6> L <30 30 30 30 30 30>
ABS ceil_abs = <30 40 50 60 70 80> L <30 30 30 30 30 30>

MIRROR 100 200

CORNERS

;id x y z

 1 pw+tw/2   0       0
 2 x(1)      ep      0
 3 x(1)+ed   ep      0
 4 x(3)      y(2)+ew 0
 5 x(1)      y(4)    0 
 6 x(1)      sl      0
 7 tw/2      sl      0
 8 x(7)      0       0
 9 x(2)      y(2)    eh
10 x(9)+ed   y(2)    eh
11 x(10)+sd  y(2)    eh+sh
12 x(11)     y(5)    z(11)
13 x(10)     y(5)    eh
14 x(5)      y(5)    eh
15 x(11)     y(11)   sh
16 x(12)     y(12)   sh
17 x(6)      y(6)    wh
18 x(1)      0       wh
20 x(7)      y(7)    tlevel
21 x(8)      y(8)    tlevel
22 trd/2     y(7)    tlevel
23 trd/2     0       tlevel
30 x(20)     y(20)   trh+tlevel
31 x(21)     y(21)   trh+tlevel
32 x(22)     y(22)   trh+tlevel
33 x(23)     y(23)   trh+tlevel
34 x(7)      y(7)    tunh
35 x(8)      0     tunh

IF -flat_ceiling THEN
;ceiling arch circular
   40 r*sin(0*a) 0  wh+r*zh*cos(0*a)
   41 r*sin(1*a) 0  wh+r*zh*cos(1*a)
   42 r*sin(2*a) 0  wh+r*zh*cos(2*a)
   43 r*sin(3*a) 0  wh+r*zh*cos(3*a)
   44 r*sin(4*a) 0  wh+r*zh*cos(4*a)
   45 r*sin(5*a) 0  wh+r*zh*cos(5*a)
   50 r*sin(0*a) sl wh+r*zh*cos(0*a)
   51 r*sin(1*a) sl wh+r*zh*cos(1*a)
   52 r*sin(2*a) sl wh+r*zh*cos(2*a)
   53 r*sin(3*a) sl wh+r*zh*cos(3*a)
   54 r*sin(4*a) sl wh+r*zh*cos(4*a)
   55 r*sin(5*a) sl wh+r*zh*cos(5*a)
ENDIF

;side wall absorber division
60 x(1) y(1) side_ah
61 x(1) y(9) side_ah
62 x(1) y(14) side_ah
63 x(1) y(6) side_ah

;end wall absorber division
64 x(6) y(6) z(34)
65 x(1) 0    z(34)

PLANES

[ 1 platform  / 6 7 8 1 2 3 4 5 / platform_abs  ]

IF side_ah <= eh THEN
   [ 2 sidewall  / 17 6 5 14 9 2 1 18 / 
      ( upper side wall abs  / 60 18 17 63 62 14 9 61  / usidewall_abs )
      ( lower side wall abs 1 / 1 2 61 60   / lsidewall_abs )
      ( lower side wall abs 2 / 5 62 63 6   / lsidewall_abs )
    ]
ENDIF

IF side_ah > eh THEN
   [ 2 sidewall  / 17 6 5 14 9 2 1 18 / 
      ( upper side wall abs  / 60 18 17 63 / usidewall_abs )
      ( lower side wall abs / 1 2 9 14 5 6 63 60   / lsidewall_abs )
    ]
ENDIF

[ 3 stairs  /  16 4 3 15   / stair_abs  ]
[ 4 stair wall  / 5 4 16 12 13 14 / stairwall_abs  ]
[ 5 stair wall / 3 2 9 10 11 15  / stairwall_abs  ]
[ 6 entrance ceiling  / 10 9 14 13   / stairceil_abs  ]
[ 7 stair ceiling  / 12 11 10 13   / stairceil_abs  ]
[ 8 stair opening  / 16 15 11 12   / opening  ]

IF flat_ceiling THEN
   [ 13 end wall y=sl / 6 17 117 106 107 130 134 34 30 7  / 
      ( upper end wall abs  / 64 17 117 164 134 34 / uendwall_abs )
      ( lower end wall abs 1 / 6 7 34 64 / lendwall_abs )
      ( lower end wall abs 2 / 107 106 164 134 / lendwall_abs )
   ]
   [ 14 end wall y=0 / 18 1 8 31 35 135 131 108 101 118 / 
      ( upper end wall abs  / 65 35 135 165 118 18 / uendwall_abs )
      ( lower end wall abs 1 / 1 8 35 65 / lendwall_abs )
      ( lower end wall abs 2 / 108 101 165 135 / lendwall_abs )
   ]
ENDIF

IF -flat_ceiling THEN
   [ 13 end wall y=sl / 7 6 17 55 54 53 52 51 50 151 152 153 154 155 117 106 107 134 34  / 
      ( upper end wall abs  / 34 64 17 55 54 53 52 51 50 151 152 153 154 155 117 164 134 / uendwall_abs )
      ( lower end wall abs 1 / 6 7 34 64 / lendwall_abs )
      ( lower end wall abs 2 / 107 106 164 134 / lendwall_abs )
   ]
   [ 14 end wall y=0 \ 8 1 18 45 44 43 42 41 40 141 142 143 144 145 118 101 108 135 35  \ 
      ( upper end wall abs  / 35 65 18 45 44 43 42 41 40 141 142 143 144 145 118 165 135  / uendwall_abs )
      ( lower end wall abs 1 / 1 8 35 65 / lendwall_abs )
      ( lower end wall abs 2 / 108 101 165 135 / lendwall_abs )
   ]
ENDIF

IF flat_ceiling+use_trains THEN
   [ 9 inbetw. tracks / 22 122 123 23   / track_abs ]
   [ 10 outer train side / 7 30 31 8  / train_abs  ]
   [ 11 inner train side / 23 33 32 22  / train_abs  ]
   [ 12 train roof  / 30 32 33 31   / train_abs  ]
   [ 15 opening  y=s1 / 34 134 130 132 122 22 32 30  / opening  ]
   [ 16 opening  y=0  / 23 123 133 131 135 35 31 33 / opening  ]
   [ 17 ceiling / 18 118 117 17   / ceil_abs  ]
ENDIF

IF flat_ceiling-use_trains THEN
   [ 9 track side / 7 20 21 8  / trackwall_abs ]
   [ 10 track level  / 20 22 122 120 121 123 23 21 /
      (tracks  / 20 22 23 21   / track_abs )
      (inbetw. tracks / 22 122 123 23   / track_abs )
   ]
   [ 15 opening  y=s1 / 20 7 34 134 107 120 122 22 / opening  ]
   [ 16 opening  y=0  \ 21 8 35 135 108 121 123 23 \ opening  ]
   [ 17 ceiling / 18 118 117 17   / ceil_abs  ]
ENDIF

IF -flat_ceiling+use_trains THEN
   [ 9 inbetw. tracks / 22 122 123 23   / track_abs ]
   [ 10 outer train side / 7 30 31 8  / train_abs  ]
   [ 11 inner train side / 23 33 32 22  / train_abs  ]
   [ 12 train roof  / 30 32 33 31   / train_abs  ]
   [ 15 opening  y=s1 / 34 134 130 132 122 22 32 30  / opening  ]
   [ 16 opening  y=0  / 23 123 133 131 135 35 31 33 / opening  ]
   [ 17 ceiling part / 17 18 45 55  / ceil_abs ]
   [ 18 ceiling part / 45 44 54 55  / ceil_abs ]
   [ 19 ceiling part / 44 43 53 54  / ceil_abs ]
   [ 20 ceiling part / 43 42 52 53  / ceil_abs ]
   [ 21 ceiling part / 42 41 51 52  / ceil_abs ]
   [ 22 ceiling part / 41 40 50 51  / ceil_abs ]
ENDIF

IF -flat_ceiling-use_trains THEN
   [ 9 track side / 7 20 21 8  / trackwall_abs ]
   [ 10 track level  / 20 22 122 120 121 123 23 21 /
      (tracks  / 20 22 23 21   / track_abs )
      (inbetw. tracks / 22 122 123 23   / track_abs )
   ]
   [ 15 opening  y=s1 / 20 7 34 134 107 120 122 22 / opening  ]
   [ 16 opening  y=0  \ 21 8 35 135 108 121 123 23 \ opening  ]
   [ 17 ceiling part / 17 18 45 55  / ceil_abs ]
   [ 18 ceiling part / 45 44 54 55  / ceil_abs ]
   [ 19 ceiling part / 44 43 53 54  / ceil_abs ]
   [ 20 ceiling part / 43 42 52 53  / ceil_abs ]
   [ 21 ceiling part / 42 41 51 52  / ceil_abs ]
   [ 22 ceiling part / 41 40 50 51  / ceil_abs ]
ENDIF

