;MASTER.GEO
;PROJECT=Factory


ABS default = <10 10 10 10 10 10> ;L <10 10 10 10 10 10>
ABS floor_abs = default
ABS ceiling_abs = default
ABS upperwall_abs = default
ABS lowerwall_abs = default


;in this file the objects to use is selected
INCLUDE objects.GEO 

GLOBAL fw = 20 ; floor width
GLOBAL fl = 40 ; floor length
GLOBAL  h = 10 ; height
GLOBAL ah =  8 ; height where upperwall_abs starts
GLOBAL  a =  0 ; wall angles (> 0 gives inwards tilt)

;derrived, don't change
LOCAL dz = ah/h

CORNERS

 1   fw/2  0  0
 2   fw/2 fl  0
 3  -fw/2 fl  0
 4  -fw/2  0  0
 6   fw/2-h*sin(a) h*sin(a)    h
 7   x(6)          fl-h*sin(a) h
 8  -x(6)          y(7)        h
 9  -x(6)          y(6)        h
10   x(1)+(x(6)-x(1))*dz  y(1)+(y(6)-y(1))*dz z(6)*dz
11   x(2)+(x(7)-x(2))*dz  y(2)+(y(7)-y(2))*dz z(7)*dz
12   x(3)+(x(8)-x(3))*dz  y(3)+(y(8)-y(3))*dz z(8)*dz
13   x(4)+(x(9)-x(4))*dz  y(4)+(y(9)-y(4))*dz z(9)*dz

PLANES

[ 1 floor  / 1 2 3 4 / floor_abs  ] 
[ 2 ceiling  / 9 8 7 6 / ceiling_abs  ]
[ 3 end-wall  / 1 4 9 6 /
  ( upper wall / 13 9 6 10 /  upperwall_abs )
  ( lower wall / 1 4 13 10 / lowerwall_abs )
]
[ 4 back-wall  / 2 7 8 3 / 
  ( upper wall / 11 12 8 7 /  upperwall_abs )
  ( lower wall / 2 3 12 11 / lowerwall_abs )
]
[ 5 left side-wall  / 3 8 9 4  / 
  ( upper wall / 13 12 8 9 /  upperwall_abs )
  ( lower wall / 13 4 3 12 / lowerwall_abs )
]
[ 6 right side-wall  / 1 10 6 7 11 2   / 
  ( upper wall / 10 6 7 11 /  upperwall_abs )
  ( lower wall / 1 10 11 2 / lowerwall_abs )
]
