;MASTER.GEO
;PROJECT=Concept Halls: Listening Room #1

ABS default        = <15 12 10 8 7 6>
ABS wall_rear_u    = default ;rear  wall upper  part
ABS wall_rear_m    = default ;rear  wall middle part
ABS wall_rear_l    = default ;rear  wall lower  part
ABS wall_front_u   = default ;front wall upper  part
ABS wall_front_m   = default ;front wall middle part
ABS wall_front_l   = default ;front wall lower  part
ABS wall_side_u    = default ;side walls upper  part
ABS wall_side_mf   = default ;side walls middle front part
ABS wall_side_mr   = default ;side walls middle rear part
ABS wall_side_l    = default ;side walls lower  part

ABS ceiling      = default 
ABS floor        = default
ABS soffit_edge  = default
ABS soffit       = default
ABS corner       = default ; the corner boxes

;General room sizes
GLOBAL w   = 4.5 ; room width
GLOBAL d   = 7   ; room dpth (length)
GLOBAL c_h = 3   ; ceiling height
GLOBAL w_h = 2.8 ; wall height
GLOBAL s_w = 0.8 ; ceiling soffit width
GLOBAL c_s = 0.3 ; corner stuff side size

;vertical thirds
GLOBAL h3_m = 0.5     ; height of middle vertical abs/diff division
GLOBAL h3_u = w_h-0.5 ; height of upper  vertical abs/diff division

;middle vertical side wall third division
GLOBAL d3_m = d/2

;check for some impossible measures
IF c_h = w_h THEN
   BREAK ** c_h must be # w_h
ENDIF
IF h3_u <= h3_m THEN
   BREAK ** h3_m must be <= h3_u
ENDIF
IF c_s < 0.1 THEN
   BREAK ** c_s must be >= 0.1 m
ENDIF
IF s_w < 0.1 THEN
   BREAK ** c_w must be >= 0.1 m
ENDIF

;---------------------------------
;listening (receiver) position
;needed here since it is used  
;also in the src-file to place 
;the speakers.
GLOBAL r_x = 0
GLOBAL r_y = d/2
GLOBAL r_h = 1.2
;---------------------------------

INCLUDE implement.GEO ;here is where the actual room is created

CORNERS
   ;no corners defined here, all is done in implement.GEO
PLANES
   ;no planes defined here, all is done in implement.GEO

